
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)
# Data
models = ["Model A", "Model B", "Model C"]
accuracy_improvement = {
    "Baseline": [0.80, 0.82, 0.78],
    "Experiment 1": [0.85, 0.84, 0.81],
    "Experiment 2": [0.88, 0.87, 0.83],
    "Experiment 3": [0.90, 0.88, 0.85],
    "Experiment 4": [0.92, 0.90, 0.87],
    "Experiment 5": [0.93, 0.92, 0.89],
}

# Plot labels and types
ylabel_text = "Accuracy Improvement"
xlabel_text = "Models"
title_text = "Model Accuracy Improvement Comparison"
legend_title = "Training Conditions"

# Plot limits and ticks
ylim_values = (0.75, 1)  # accuracies range from 0 to 1
yticks_values = [0.75, 0.8, 0.85, 0.9, 0.95, 1.0]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
bar_label_fontsize = 10
ylabel_fontsize = 12

# Colors for the bars
colors = ["#4c72b0", "#55a868", "#c44e52", "#8172b3", "#ccb974", "#64b5cd"]

# Setup the figure and axes
fig, ax = plt.subplots(figsize=(12, 4))

# Bar width
bar_width = 0.1

# Positions of the bars on the x-axis
r = np.arange(len(models))

# Create bars for each training condition
for i, (condition, values) in enumerate(accuracy_improvement.items()):
    ax.bar(
        r + i * bar_width,
        values,
        color=colors[i],
        width=bar_width,
        edgecolor="white",
        label=condition,
    )

# Add labels on top of the bars
for i, (condition, values) in enumerate(accuracy_improvement.items()):
    for j, value in enumerate(values):
        ax.text(
            j + i * bar_width,
            value + 0.005,
            f"{value:.2f}",
            ha="center",
            va="bottom",
            fontsize=bar_label_fontsize,
        )

# General layout
ax.set_ylabel(ylabel_text, fontsize=ylabel_fontsize)
ax.set_xticks(r + bar_width * (len(accuracy_improvement) - 1) / 2)
ax.set_xticklabels(models)
ax.set_ylim(*ylim_values)
ax.set_yticks(yticks_values)
ax.legend(
    title=legend_title,
    loc="upper center",
    bbox_to_anchor=(0.5, 1.2),
    frameon=False,
    ncol=7,
)
ax.set_facecolor("#f0f0f5")
ax.yaxis.grid(True, color="white")
ax.set_axisbelow(True)

# Remove spines
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.spines["bottom"].set_visible(False)
ax.spines["left"].set_visible(False)

plt.tick_params(axis="both", which="both", length=0)

# ===================
# Part 4: Saving Output
# ===================
fig.set_size_inches(12, 4)
plt.tick_params(axis="both", which="both", length=0)
plt.tight_layout()
plt.savefig("bar_189.pdf", bbox_inches="tight")
