
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data preparation
models = ["Model-A", "Model-B", "Model-C", "Model-D", "Model-E", "Model-F"]
fiction = [35, 45, 50, 60, 70, 55]
non_fiction = [30, 40, 35, 50, 60, 45]
sci_fi = [20, 25, 30, 35, 40, 30]
confused = [15, 18, 10, 20, 30, 25]

# Bar positions
x = np.arange(len(models))
labels = [
    "Fiction",
    "Non-Fiction",
    "Science Fiction",
    "Confused",
]
ylabel = "Categorization Accuracy (%)"
title = "AI Models' Performance in Book Categorization"
xlabel = "AI Models"
ylim = [0, 100]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
width = 0.15  # Width of the bars
# Plotting
fig, ax = plt.subplots(figsize=(8, 6))  # Adjusting figure size

# Plot bars for each category
ax.bar(x - width * 1.5, fiction, width, label=labels[0], color="#66c2a5")
ax.bar(x - width * 0.5, non_fiction, width, label=labels[1], color="#fc8d62")
ax.bar(x + width * 0.5, sci_fi, width, label=labels[2], color="#8da0cb")
ax.bar(x + width * 1.5, confused, width, label=labels[3], hatch="//", color="#e78ac3")

# Labels and Title
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.set_xlabel(xlabel)
ax.set_xticks(x)
ax.set_xticklabels(models)
ax.set_ylim(ylim)  # Adjusted y-axis limit

# Move legend inside the plot area
ax.legend(loc="upper left")

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_193.pdf", bbox_inches="tight")
