
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data
players = ["Player A", "Player B", "Player C", "Player D", "Player E"][::-1]
points_scored = [1200, 900, 1500, 1100, 800][::-1]
assists = [300, 340, 290, 280, 310][::-1]
rebounds = [400, 450, 420, 410, 390][::-1]

labels = ["Points Scored", "Assists", "Rebounds"]
y_pos = range(len(players))

# Text labels
xlabel = "Statistics"
ylabel = "Players"
title = "Basketball Player Statistics"
legend_labels = ["Points Scored", "Assists", "Rebounds"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
bar_width = 0.5
# Stacked Bar Chart
fig, ax = plt.subplots(figsize=(10, 6))  # Adjusted to match typical presentation format

# Bar colors
colors = ['#003f5c', '#7a5195', '#ef5675']

# Plotting the bars
ax.barh(y_pos, points_scored, bar_width, color=colors[0], label=legend_labels[0])
ax.barh(y_pos, assists, bar_width, left=points_scored, color=colors[1], label=legend_labels[1])
ax.barh(
    y_pos,
    rebounds,
    bar_width,
    left=[i + j for i, j in zip(points_scored, assists)],
    color=colors[2],
    label=legend_labels[2],
)

# Adding the numerical values within each segment
for i in range(len(players)):
    ax.text(
        points_scored[i] / 2,
        i,
        str(points_scored[i]),
        ha="center",
        va="center",
        color="white",
    )
    ax.text(
        points_scored[i] + assists[i] / 2,
        i,
        str(assists[i]),
        ha="center",
        va="center",
        color="white",
    )
    ax.text(
        points_scored[i] + assists[i] + rebounds[i] / 2,
        i,
        str(rebounds[i]),
        ha="center",
        va="center",
        color="white",
    )

# Labels and Legend
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_xticks([])
ax.set_yticks(y_pos)
ax.set_yticklabels(players)
ax.set_title(title)
ax.legend(loc="upper right")

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with a tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_196.pdf", bbox_inches="tight")
