
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data
categories = [
    "Revenue Growth",
    "Net Income",
    "Earnings Per Share",
    "Gross Margin",
    "Operating Margin",
    "EBITDA",
    "Cash Flow",
    "Debt to Equity Ratio",
    "Return on Equity",
    "Return on Assets",
    "Dividend Yield",
    "Stock Price Change",
    "P/E Ratio",
    "Market Cap",
    "Total Assets",
    "Total Liabilities",
    "Equity Value",
    "Enterprise Value",
]
differences = [
    -5,
    15,
    8,
    -12,
    5,
    20,
    30,
    -10,
    25,
    12,
    7,
    40,
    -3,
    60,
    50,
    -8,
    70,
    35,
]

title = "Relative Differences in Financial Metrics"
xlabel = "Difference (%)"
ylabel = "Financial Metric"
xlim = [-20, 80]
xticks = range(-20, 81, 20)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#ff6f61" if x < 0 else "#6baed6" for x in differences]  # Red for negative, Blue for positive
hatches = ["//" if x < 0 else "" for x in differences]  # Hatching for negative bars

# Create figure and plot
fig, ax = plt.subplots(figsize=(12, 7))
bars = ax.barh(categories, differences, color=colors)

# Apply hatches to negative bars
for bar, hatch in zip(bars, hatches):
    bar.set_hatch(hatch)

# Set title and labels
ax.set_title(title, fontsize=16, weight='bold')
ax.set_xlabel(xlabel, fontsize=14)
ax.set_ylabel(ylabel, fontsize=14)

# Set x-axis limits and labels
ax.set_xlim(xlim)
ax.set_xticks(xticks)
ax.xaxis.grid(True)

# Annotate significant bars
for bar in bars:
    width = bar.get_width()
    label_x_pos = width if width < 0 else width
    ax.text(label_x_pos, bar.get_y() + bar.get_height()/2, f'{width}%', va='center', ha='left' if width < 0 else 'right', fontsize=12, color='black')

# ===================
# Part 4: Saving Output
# ===================
# Save the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_199.pdf", bbox_inches="tight")
