
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data
countries = [
    "Canada",
    "Russia",
    "Brazil",
    "Mexico",
    "Australia",
    "India",
    "China",
    "USA",
    "UK",
    "Germany",
    "France",
    "Japan",
    "South Korea",
    "South Africa",
    "Argentina",
    "Italy",
    "Spain",
    "Turkey",
    "Saudi Arabia",
    "Indonesia",
    "Netherlands",
    "Sweden",
    "Switzerland",
    "Norway",
    "Egypt",
    "Nigeria",
    "Vietnam",
    "Thailand",
]

delta_temperature = [
    -2,
    -1.5,
    -1,
    -0.5,
    -0.2,
    0,
    0.2,
    0.5,
    1,
    1.5,
    2,
    2.5,
    3,
    3.5,
    4,
    4.5,
    5,
    5.5,
    6,
    6.5,
    7,
    7.5,
    8,
    8.5,
    9,
    9.5,
    10,
    10.5,
]

# Extracted variables
xlim_values = (-1, len(countries))
ylim_values = (-4, 12)
ylabel_text = "ΔTemp (in °C)"
title_text = "Average Temperature Changes by Country"
legend_labels = ["Decrease", "No Change", "Increase"]
yticks_values = [-4, -2, 0, 2, 4, 6, 8, 10, 12]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Colors based on delta temperature
colors = [
    "#1f77b4" if x < 0 else "#ff7f0e" if -0.5 <= x <= 0.5 else "#d62728"
    for x in delta_temperature
]

# Plot
fig, ax = plt.subplots(figsize=(8, 5))  # Convert mm to inches for figsize
bars = ax.bar(countries, delta_temperature, color=colors, edgecolor='black', alpha=0.7)

# Labels and Title
ax.set_xlim(*xlim_values)
ax.set_xticks([])
ax.set_ylim(*ylim_values)
ax.set_yticks(yticks_values)
ax.set_ylabel(ylabel_text)
ax.set_title(title_text)

# Add text labels
for bar, country in zip(bars, countries):
    y = bar.get_height()
    if y < 0:
        ax.text(
            bar.get_x() + bar.get_width() / 2,
            0.2,
            country,
            rotation=90,
            ha="center",
            va="bottom",
        )
    else:
        ax.text(
            bar.get_x() + bar.get_width() / 2,
            -0.2,
            country,
            rotation=90,
            ha="center",
            va="top",
        )

# Legend
blue_patch = plt.Rectangle((0, 0), 1, 1, fc="#1f77b4", edgecolor="none")
orange_patch = plt.Rectangle((0, 0), 1, 1, fc="#ff7f0e", edgecolor="none")
red_patch = plt.Rectangle((0, 0), 1, 1, fc="#d62728", edgecolor="none")
ax.legend(
    [blue_patch, orange_patch, red_patch],
    legend_labels,
    loc="lower center",
    bbox_to_anchor=(0.5, -0.1),
    ncol=3,
    frameon=False,
)

plt.tick_params(axis="both", which="both", length=0)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout()
plt.savefig("bar_205.pdf", bbox_inches="tight")
