
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)
# Placeholder data for health and performance metrics of AI models
categories = [
    "Model A",
    "Model B",
    "Model C",
    "Model D",
    "Model E",
    "Model F",
    "Model G",
    "Model H",
    "Model I",
    "Model J",
    "Model K",
]
scores = {
    "Dataset 1": [48.1, 50.4, 57.2, 59.3, 45.9, 64.9, 48.4, 57.6, 62.3, 69.1, 54.3],
    "Dataset 2": [56.0, 60.8, 62.2, 64.4, 51.7, 64.4, 58.0, 67.6, 76.5, 80.2, 58.0],
    "Dataset 3": [64.4, 65.8, 66.8, 67.4, 66.8, 69.0, 66.2, 69.0, 71.8, 72.0, 70.7],
    "Dataset 4": [55.6, 56.3, 60.4, 65.6, 58.5, 61.1, 54.1, 63.7, 74.4, 79.6, 66.7],
    "Dataset 5": [60.2, 59.4, 69.2, 67.7, 54.2, 72.3, 57.9, 70.4, 78.7, 85.8, 66.7],
    "Dataset 6": [68.5, 58.8, 74.0, 76.1, 56.7, 84.8, 68.5, 78.9, 85.8, 83.2, 78.0],
    "Dataset 7": [58.8, 47.8, 57.6, 59.4, 51.3, 68.6, 53.6, 66.3, 73.2, 79.0, 59.2],
    "Dataset 8": [62.0, 61.0, 66.0, 75.0, 56.0, 72.0, 66.0, 65.0, 82.0, 83.0, 65.8],
    "Dataset 9": [66.8, 58.8, 69.8, 70.9, 55.4, 73.1, 64.3, 73.8, 85.2, 85.2, 67.7],
}

ylim = [40, 90]
ylabel = "Performance Score (%)"
yticks = [40, 50, 60, 70, 80, 90]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(12, 10))

# Create subplots for each dataset
n_rows = 3
n_cols = 3
subplot_idx = 1
for category, score in scores.items():
    ax = plt.subplot(n_rows, n_cols, subplot_idx)
    subplot_idx += 1

    # Create bar chart
    x = np.arange(len(categories))
    colors = [
        "#3E92CC", "#48C9B0", "#F4D03F", "#EC7063", "#AF7AC5",
        "#F39C12", "#52BE80", "#5DADE2", "#E74C3C", "#A569BD", "#F5B041"
    ]
    ax.bar(
        x,
        score,
        color=colors,
    )

    # Add data labels
    for j, val in enumerate(score):
        ax.text(j, val + 1, f"{val:.1f}", ha="center", va="bottom", fontsize=8)

    # Set title and labels
    ax.set_title(category, fontsize=10)
    ax.set_xticks(x)
    ax.set_xticklabels(categories, rotation=45, ha="right", fontsize=8)
    ax.set_ylim(ylim)
    ax.set_ylabel(ylabel, fontsize=9)
    ax.set_yticks(yticks)

    plt.tick_params(axis="both", which="both", length=0)
    ax.grid(True, axis='y', linestyle='--', linewidth=0.7, alpha=0.7)
    ax.set_axisbelow(True)
    ax = plt.gca()

    # Remove top and right spines
    ax.spines["top"].set_visible(False)
    ax.spines["right"].set_visible(False)
    ax.spines["bottom"].set_color("gray")
    ax.spines["left"].set_color("gray")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout()
plt.savefig("bar_207.pdf", bbox_inches="tight")
