
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)

# Placeholder data
categories = [
    "ResNet-50",
    "ResNet-101",
    "EfficientNet-B0",
    "EfficientNet-B7",
    "VGG-16",
    "VGG-19",
    "DenseNet-121",
    "DenseNet-201",
    "InceptionV3",
    "MobileNetV2",
    "NASNetMobile",
]
scores = {
    "CIFAR-10": [93.5, 94.2, 92.8, 95.7, 91.3, 91.8, 93.0, 94.1, 93.6, 92.1, 90.8],
    "CIFAR-100": [74.0, 74.8, 72.9, 76.1, 70.6, 71.2, 74.3, 75.4, 73.7, 71.6, 70.1],
    "ImageNet": [76.1, 77.2, 74.4, 79.1, 71.6, 72.1, 76.0, 77.5, 76.8, 74.2, 72.9],
    "SVHN": [96.5, 97.1, 96.0, 97.6, 95.3, 95.7, 96.4, 96.8, 96.7, 95.9, 94.8],
    "Fashion-MNIST": [93.2, 93.8, 92.7, 94.5, 91.1, 91.5, 92.9, 93.7, 93.3, 92.4, 91.0],
    "MNIST": [99.0, 99.2, 98.8, 99.4, 98.5, 98.7, 99.0, 99.2, 99.1, 98.7, 98.3],
    "TinyImagenet": [60.2, 61.5, 58.4, 63.1, 56.7, 57.1, 60.3, 61.8, 60.9, 58.5, 56.3],
}

ylim = [50, 100]
ylabel = "Performance Accuracy (%)"
yticks = [50, 60, 70, 80, 90, 100]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(12, 10))

# Create subplots for each category
n_rows = 3
n_cols = 3
subplot_idx = 1
for category, score in scores.items():
    ax = plt.subplot(n_rows, n_cols, subplot_idx)
    subplot_idx += 1

    # Create bar chart
    x = np.arange(len(categories))
    ax.bar(
        x,
        score,
        color=[
            "#ff9999",
            "#66b3ff",
            "#99ff99",
            "#ffcc99",
            "#c2c2f0",
            "#ffb3e6",
            "#c4e17f",
            "#ffccff",
            "#ff6666",
            "#c2c2f0",
            "#ffb366",
        ],
    )

    # Add data labels
    for j, val in enumerate(score):
        ax.text(j, val + 1, f"{val:.1f}", ha="center", va="bottom", fontsize=6)

    # Set title and labels
    ax.set_title(category, fontsize=10)
    ax.set_xticks(x)
    ax.set_xticklabels(categories, rotation=45, ha="right", fontsize=7)
    ax.set_ylim(ylim)
    ax.set_ylabel(ylabel, fontsize=8)
    ax.set_yticks(yticks)

    ax.tick_params(axis="both", which="both", length=0, labelsize=7)

    # Add y grid
    ax.yaxis.grid(True)
    ax.set_axisbelow(True)

    ax.spines["top"].set_color("gray")
    ax.spines["right"].set_color("gray")
    ax.spines["bottom"].set_color("gray")
    ax.spines["left"].set_color("gray")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout()
plt.savefig("bar_208.pdf", bbox_inches="tight")

