
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Placeholder data for psychology sub-fields
categories = [
    "Clinical Psychology",
    "Cognitive Psychology",
    "Developmental Psychology",
    "Social Psychology",
    "Health Psychology",
    "Educational Psychology",
    "Industrial-Organizational Psychology",
    "Neuropsychology",
    "Forensic Psychology",
    "Sports Psychology",
]
# Hypothetical data values
values_2021 = np.random.randint(15, 50, size=len(categories))
values_2022 = np.random.randint(20, 60, size=len(categories))

# Positions of the bars on the x-axis
r = np.arange(len(categories))

# Labels and attributes
labels = ["2021", "2022"]
xlabel = "Psychology Sub-fields"
ylabel = "Number of Published Studies"
title = "Comparison of Published Studies in Psychology Sub-fields: 2021 vs 2022"
legend_labels = ["2021", "2022"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Bar width
bar_width = 0.6

# Create the figure and the axes
fig, ax = plt.subplots(figsize=(10, 7))

# Plot the bars with new color scheme
ax.bar(
    r,
    values_2021,
    bottom=values_2022,
    color="#8da0cb",
    width=bar_width,
    label=legend_labels[0],
)
ax.bar(r, values_2022, color="#66c2a5", width=bar_width, label=legend_labels[1])

# Add labels, title, and legend
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_xticks(r)
ax.set_xticklabels(categories, rotation=45, ha="right")
ax.set_title(title)
ax.legend(loc="upper right")

# Enhance the aesthetics
plt.grid(True, linestyle='--', linewidth=0.5, alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout
plt.tight_layout()
plt.savefig("bar_211.pdf", bbox_inches="tight")
