
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data
diets = ["Paleo", "Keto", "Vegan", "Mediterranean", "DASH", "Whole30", "Flexitarian"]
percentages = [4.0, 7.5, 10.2, 12.3, 9.1, 3.8, 5.6]
title = "Adoption of Various Health Diets"
xlabel = "Diet Type"
ylabel = "Adoption Percentage (%)"
ylim = [0, 15]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and bar chart
plt.figure(figsize=(12, 8))
colors = ["#76c7c0", "#ff9a8d", "#f5e663", "#6c5ce7", "#74b9ff", "#55efc4", "#ff7675"]

bars = plt.bar(diets, percentages, color=colors, edgecolor="black")

# Add percentage labels on top of each bar
for bar in bars:
    yval = bar.get_height()
    plt.text(
        bar.get_x() + bar.get_width() / 2, yval, f"{yval}%", ha="center", va="bottom", fontsize=10
    )

# Set chart title and labels
plt.title(title, fontsize=16, fontweight='bold')
plt.xlabel(xlabel, fontsize=14)
plt.ylabel(ylabel, fontsize=14)

# Set y-axis range and gridlines
plt.ylim(*ylim)
plt.grid(axis="y", linestyle="--", alpha=0.7)

# Remove top and right spines for a cleaner look
plt.gca().spines["top"].set_visible(False)
plt.gca().spines["right"].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_216.pdf", bbox_inches="tight")
