
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data
crops = ["Wheat", "Corn", "Rice", "Barley", "Soybean", "Oats", "Sorghum"]
yield_improvements = [5, 12, 8, 3, 10, 7, 9]
title = "Crop Yield Improvement Due to New Technique"
xlabel = "Crop"
ylabel = "Yield Improvement (%)"
ylim = [0, 15]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Custom color palette with earthy tones
colors = ["#8FBC8F", "#6B8E23", "#556B2F", "#228B22", "#2E8B57", "#3CB371", "#32CD32"]

# Create figure and bar chart
plt.figure(figsize=(10, 6))
bars = plt.bar(crops, yield_improvements, color=colors)

# Add percentage labels on top of each bar
for bar in bars:
    yval = bar.get_height()
    plt.text(
        bar.get_x() + bar.get_width() / 2, yval, f"{yval}%", ha="center", va="bottom",
        fontweight='bold', color='brown'
    )

# Set chart title and labels
plt.title(title, fontsize=14, fontweight='bold')
plt.xlabel(xlabel, fontsize=12)
plt.ylabel(ylabel, fontsize=12)

# Set y-axis range and gridlines
plt.ylim(ylim)
plt.grid(axis="y", linestyle="--", linewidth=0.7, alpha=0.7)

# Remove top and right spines for a cleaner look
plt.gca().spines["top"].set_visible(False)
plt.gca().spines["right"].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_217.pdf", bbox_inches="tight")
