
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
political_strategies = ["Strategy A", "Strategy B", "Strategy C", "Strategy D"]
approval_ratings = [0.70, 0.65, 0.80, 0.75]
policy_effectiveness = [0.60, 0.55, 0.70, 0.65]

labels = ["Approval Rating", "Policy Effectiveness"]

# X-axis positions
x = np.arange(len(political_strategies))
indexs = [2, 4]

# Plot labels
approval_title = "(a) Approval Ratings"
effectiveness_title = "(b) Policy Effectiveness"
ylabel_approval = "Approval Rating"
ylabel_effectiveness = "Effectiveness Score"
yticks_approval = [0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0]
yticks_effectiveness = [0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create subplots
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(5, 6))
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728"]
barwidth = 0.3
# Approval Ratings subplot
for i in range(len(x)):
    ax1.bar(
        (i - 2) * 0.3 + indexs[0],
        approval_ratings[i],
        width=0.3,
        label="Approval Rating" if i == 0 else "",  # Label only once for legend
        color=colors[i],
    )
    ax1.bar(
        (i - 2) * 0.3 + indexs[1],
        policy_effectiveness[i],
        width=0.3,
        label="Policy Effectiveness" if i == 0 else "",  # Label only once for legend
        color=colors[i],
    )
ax1.set_title(approval_title)
ax1.set_xticks([index - 0.15 for index in indexs])
ax1.set_xticklabels(labels)
ax1.set_ylabel(ylabel_approval)
ax1.set_yticks(yticks_approval)
ax1.tick_params(axis="both", which="both", length=0)
ax1.legend()

# Policy Effectiveness subplot
for i in range(len(x)):
    ax2.bar(
        (i - 2) * 0.3 + indexs[0],
        approval_ratings[i],
        width=0.3,
        label="Approval Rating" if i == 0 else "",  # Label only once for legend
        color=colors[i],
    )
    ax2.bar(
        (i - 2) * 0.3 + indexs[1],
        policy_effectiveness[i],
        width=0.3,
        label="Policy Effectiveness" if i == 0 else "",  # Label only once for legend
        color=colors[i],
    )
ax2.set_title(effectiveness_title)
ax2.set_xticks([index - 0.15 for index in indexs])
ax2.set_xticklabels(labels)
ax2.set_ylabel(ylabel_effectiveness)
ax2.set_yticks(yticks_effectiveness)
ax2.tick_params(axis="both", which="both", length=0)
ax2.legend()

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("bar_224.pdf", bbox_inches="tight")
