
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
years = ["2010", "2015", "2020", "2025"]
north_population = [5.2, 5.5, 5.8, 6.0]
south_population = [3.8, 4.0, 4.4, 4.5]
east_population = [4.5, 4.8, 5.0, 5.3]
west_population = [3.0, 3.3, 3.5, 3.7]

labels = ["North", "South", "East", "West"]
xlabel = "Years"
ylabel = "Population (Millions)"
title = "Population Distribution by Region Over Years"
yaxhline = 6
ylim = [0, 7]
yticks = np.arange(0, 8, 1)

# Positions of bars on x-axis
ind = np.arange(len(years))

texts = ["5.2M", "5.5M", "5.8M", "6.0M"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Bar width
bar_width = 0.2

# Figure size
plt.figure(figsize=(10, 7))

# Plotting
plt.bar(ind, north_population, width=bar_width, label=labels[0], color="#4CAF50", hatch="//")
plt.bar(ind + bar_width, south_population, width=bar_width, label=labels[1], color="#FF9800", hatch="\\")
plt.bar(ind + 2 * bar_width, east_population, width=bar_width, label=labels[2], color="#2196F3", hatch="..")
plt.bar(ind + 3 * bar_width, west_population, width=bar_width, label=labels[3], color="#9C27B0", hatch="xx")

# Annotating data points
for i in range(len(years)):
    plt.annotate(texts[i], 
                 xy=(ind[i], north_population[i]), 
                 xytext=(ind[i], north_population[i] + 0.2),
                 ha='center', va='bottom', fontsize=10, color='black')

plt.axhline(y=yaxhline, color="red", linestyle="--", linewidth=2)

# X-axis labels
plt.xticks(ind + 1.5 * bar_width, years)

# Y-axis labels
plt.ylim(ylim)
plt.yticks(yticks)

# Legend
plt.legend(loc="upper left")

# Grid lines
plt.grid(axis="y", linestyle='--', alpha=0.7)

# Labels and Title
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_225.pdf", bbox_inches="tight")
