
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
categories = ["v1.0", "v1.1", "v1.2"]
values1 = [85, 88, 90]
values2 = [75, 78, 80]
values3 = [65, 68, 70]
values4 = [55, 58, 60]
values5 = [45, 48, 50]

values1minus = [-5, -8, -10]
values2minus = [-15, -12, -10]
values3minus = [-25, -22, -20]
values4minus = [-35, -32, -30]
values5minus = [-45, -42, -40]

# Set up the bar width
barWidth = 0.15

# Set position of bar on X axis
r1 = np.arange(len(values1))
r2 = [x + barWidth for x in r1]
r3 = [x + barWidth for x in r2]
r4 = [x + barWidth for x in r3]
r5 = [x + barWidth for x in r4]

labels = ["Usability", "Performance", "Features", "Design", "Support"]
xlabel = "Tool Versions"
ylabel = "Scores"
yticks = np.arange(-50, 101, 20)
title = "Design Tool Scores Over Versions"
legendlabels = ["Usability", "Performance", "Features", "Design", "Support"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set up the figure size
plt.figure(figsize=(10, 6))
plt.suptitle(title, fontsize=16, fontweight='bold')

# Color scheme from Coolors
colors = ["#FF6F61", "#6B5B95", "#88B04B", "#F7CAC9", "#92A8D1"]

# Make the plot
bars = []
bars.append(plt.bar(r1, values1, color=colors[0], width=barWidth, edgecolor="black", label=labels[0]))
bars.append(plt.bar(r2, values2, color=colors[1], width=barWidth, edgecolor="black", label=labels[1]))
bars.append(plt.bar(r3, values3, color=colors[2], width=barWidth, edgecolor="black", label=labels[2]))
bars.append(plt.bar(r4, values4, color=colors[3], width=barWidth, edgecolor="black", label=labels[3]))
bars.append(plt.bar(r5, values5, color=colors[4], width=barWidth, edgecolor="black", label=labels[4]))

# Minus values bars
bars.append(plt.bar(r1, values1minus, color=colors[0], width=barWidth, edgecolor="grey", label=labels[0], alpha=0.5))
bars.append(plt.bar(r2, values2minus, color=colors[1], width=barWidth, edgecolor="grey", label=labels[1], alpha=0.5))
bars.append(plt.bar(r3, values3minus, color=colors[2], width=barWidth, edgecolor="grey", label=labels[2], alpha=0.5))
bars.append(plt.bar(r4, values4minus, color=colors[3], width=barWidth, edgecolor="grey", label=labels[3], alpha=0.5))
bars.append(plt.bar(r5, values5minus, color=colors[4], width=barWidth, edgecolor="grey", label=labels[4], alpha=0.5))

# Add text on the top of each bar
for i in range(len(r1)):
    plt.text(r1[i], values1[i] - 1, str(values1[i]), ha="center", va="top", rotation=-90, fontsize=9)
    plt.text(r2[i], values2[i] - 1, str(values2[i]), ha="center", va="top", rotation=-90, fontsize=9)
    plt.text(r3[i], values3[i] - 1, str(values3[i]), ha="center", va="top", rotation=-90, fontsize=9)
    plt.text(r4[i], values4[i] - 1, str(values4[i]), ha="center", va="top", rotation=-90, fontsize=9)
    plt.text(r5[i], values5[i] - 1, str(values5[i]), ha="center", va="top", rotation=-90, fontsize=9)
    plt.text(r1[i], values1minus[i] + 1, str(-values1minus[i]), ha="center", va="bottom", rotation=-90, fontsize=9)
    plt.text(r2[i], values2minus[i] + 1, str(-values2minus[i]), ha="center", va="bottom", rotation=-90, fontsize=9)
    plt.text(r3[i], values3minus[i] + 1, str(-values3minus[i]), ha="center", va="bottom", rotation=-90, fontsize=9)
    plt.text(r4[i], values4minus[i] + 1, str(-values4minus[i]), ha="center", va="bottom", rotation=-90, fontsize=9)
    plt.text(r5[i], values5minus[i] - 1, str(-values5minus[i]), ha="center", va="top", rotation=-90, fontsize=9)

# Add xticks on the middle of the group bars
plt.xlabel(xlabel, fontsize=12)
plt.xticks([r + 2 * barWidth for r in range(len(values1))], categories, fontsize=10)
plt.yticks(yticks, fontsize=10)
plt.ylabel(ylabel, fontsize=12)
# Create legend & Show graphic
plt.legend(legendlabels, loc='upper left', bbox_to_anchor=(1,1), fontsize=9)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_229.pdf", bbox_inches="tight")
