
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data
art_genres = [
    "Abstract",
    "Surrealism",
    "Impressionism",
    "Cubism",
    "Modernism",
    "Pop Art",
    "Renaissance",
    "Baroque",
    "Neoclassical",
    "Romanticism",
]
number_of_exhibitions = [150, 200, 300, 250, 400, 350, 450, 300, 280, 320]

# Axes Limits and Labels
xlabel_value = "Number of Exhibitions"
title = "Number of Exhibitions by Art Genre"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create horizontal bar chart
plt.figure(figsize=(12, 8))  # Adjust figure size to match original image's dimensions
plt.barh(art_genres, number_of_exhibitions, color=['#FF6F61', '#6B5B95', '#88B04B', '#FFA07A', '#FFD700', '#40E0D0', '#9B870C', '#FF6347', '#87CEEB', '#FF4500'])  # Nice new colors
plt.xlabel(xlabel_value)
plt.title(title)

# Add data labels
for index, value in enumerate(number_of_exhibitions):
    plt.text(
        value + 10, index, str(value), va="center", fontsize=10
    )  # Adjust text position and font size

plt.yticks(rotation=0)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_231.pdf", bbox_inches="tight")
