
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for plotting
daily_activities = [
    "Exercise",
    "Reading",
    "Socializing",
    "Working",
    "Eating",
    "Sleeping",
    "Watching TV",
    "Browsing Internet",
    "Shopping",
    "Traveling"
]
human_distribution = [0.12, 0.08, 0.15, 0.3, 0.1, 0.2, 0.1, 0.15, 0.05, 0.05]
model_distribution = [0.1, 0.1, 0.14, 0.32, 0.11, 0.18, 0.09, 0.16, 0.04, 0.06]

x = np.arange(len(daily_activities))  # the label locations
labels = ["Observed Distribution", "Predicted Distribution"]
ylabel = "Percentage of People"
title = "Daily Activities in Society"
xlabel = "Activity"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(
    figsize=(12, 7)
)  # Adjust the figure size to match the general visual quality

# Create the bars
for i in range(len(daily_activities)):
    ax.bar(
        x[i],
        human_distribution[i],
        color="#5F9EA0",  # Teal color
        label=labels[0] if i == 0 else "",
        hatch="///",
        edgecolor="black",
    )
    ax.bar(
        x[i],
        model_distribution[i],
        bottom=human_distribution[i],
        color="#FF7F50",  # Coral color
        label=labels[1] if i == 0 else "",
        alpha=0.75,
        hatch="..",
        edgecolor="black",
    )

# Add some text for labels, title and custom x-axis tick labels, etc.
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.set_xticks(x)
ax.set_xticklabels(daily_activities, rotation=45, ha="right")
ax.set_xlabel(xlabel)
ax.legend()

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout()

plt.savefig("bar_238.pdf", bbox_inches="tight")

