
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.cm as cm

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
categories = ["France", "Spain", "USA", "China", "Italy"]
values = [89.4, 82.8, 79.7, 62.9, 58.3]  # Visitor numbers in millions
title = "Top 5 Tourist Destinations by Number of Visitors (Millions)"
xlabel = "Number of Visitors (Millions)"
xticks = np.arange(0, 101, 20)
xlabels = [str(x) for x in xticks]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create color map
colors = ["#FF6F61", "#6B5B95", "#88B04B", "#F7CAC9", "#92A8D1"]
# Create horizontal bar chart
plt.figure(figsize=(8, 5))  # Adjusting figure size for better readability
plt.barh(categories, values, color=colors)

# Adding title and labels
plt.title(title, fontsize=14)
plt.xlabel(xlabel, fontsize=12)
plt.xticks(xticks, xlabels, fontsize=10)
for spine in plt.gca().spines.values():
    spine.set_visible(False)
plt.grid(axis='x', linestyle='--', alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig("bar_240.pdf", bbox_inches="tight")
