
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Tourist activity labels
activities = [
    "Sightseeing",
    "Shopping",
    "Beach",
    "Cultural Tours",
    "Adventure Sports",
    "Dining",
    "Nature Trails",
    "Museum Visits",
    "Nightlife",
    "Relaxation",
]

# Approximate popularity values
popularity = [25.0, 20.0, 15.0, 12.0, 10.0, 8.0, 5.0, 3.0, 1.5, 0.5]
xlabel = "Popularity (%)"
ylabel = "Tourist Activities"
title = "Popularity of Tourist Activities"
super_title = "Tourism Trends in 2023"
annotation_text = "Source: Tourism Data 2023"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create horizontal bar chart
plt.figure(figsize=(10, 8))  # Adjust figure size
plt.barh(activities, popularity, color="skyblue", edgecolor="darkblue")

# Adding data labels
for index, value in enumerate(popularity):
    plt.text(value, index, f" {value}%", va="center", fontsize=10, color="darkblue", fontweight='bold')

# Set labels, title, and supertitle
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title, fontsize=14, fontweight='bold')
plt.suptitle(super_title, fontsize=16, fontweight='bold')
plt.annotate(annotation_text, xy=(0.5, -0.1), xycoords='axes fraction', ha='center', fontsize=10, color="grey")

# Style adjustments
plt.gca().spines["top"].set_visible(False)
plt.gca().spines["right"].set_visible(False)
plt.gca().spines["bottom"].set_visible(False)
plt.gca().spines["left"].set_visible(False)
plt.gca().xaxis.set_ticks_position('none') 
plt.gca().yaxis.set_ticks_position('none') 

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout(rect=[0, 0, 1, 0.95])
plt.savefig("bar_244.pdf", bbox_inches="tight")
