
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Media consumption categories
categories = [
    "Books",
    "Online Articles",
    "Podcasts",
    "Television",
    "Social Media",
    "Radio",
    "Newspapers",
    "Magazines",
    "Streaming Services",
    "Video Games",
]

# Approximate frequency values based on a plausible distribution
frequencies = [15.2, 13.4, 11.8, 12.9, 18.7, 6.5, 5.3, 4.7, 7.5, 4.0]
xlabel = "Frequency (%)"
ylabel = "Media Type"
title = "Media Consumption Distribution"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create horizontal bar chart
plt.figure(figsize=(10, 8))  # Adjust figure size
colors = plt.cm.viridis(np.linspace(0, 1, len(frequencies)))  # Use a colormap
plt.barh(categories, frequencies, color=colors, edgecolor="black", alpha=0.7)

# Adding data labels
for index, value in enumerate(frequencies):
    plt.text(value, index, f" {value}%", va="center", color='black', fontweight='bold')

# Set labels and title
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)
plt.gca().spines["top"].set_visible(False)
plt.gca().spines["right"].set_visible(False)
plt.gca().spines["bottom"].set_visible(False)
plt.gca().spines["left"].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_245.pdf", bbox_inches="tight")
