
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Media Data Example
categories = [
    "TV Ratings",
    "Social Media Engagement",
    "Subscription Growth",
    "Ad Revenue",
    "Content Production",
    "Digital Transformation",
    "Brand Value",
][::-1]
us_data = [7.5, 5.8, 8.2, 10.3, 6.1, 9.0, 7.2][::-1]
eu_data = [6.3, 4.9, 7.4, 9.1, 5.5, 8.2, 6.4][::-1]
china_data = [8.1, 7.0, 9.0, 11.4, 7.5, 10.8, 8.5][::-1]
india_data = [8.9, 6.5, 9.5, 12.0, 6.8, 10.3, 7.9][::-1]
brazil_data = [5.7, 4.2, 6.3, 8.5, 4.9, 6.8, 5.3][::-1]
labels = ["US", "EU", "China", "India", "Brazil"]

xlabel = "Metrics Value"
ylabel = "Metrics"
title = "Media Industry Performance Metrics"
legendlabels = ["US", "EU", "China", "India", "Brazil"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(8, 5))
bar_width = 0.5
y_pos = range(len(categories))

# Custom color scheme
colors = ["#FF5733", "#FFC300", "#DAF7A6", "#C70039", "#900C3F"]

ax.barh(y_pos, us_data, bar_width, color=colors[0], label=labels[0])
ax.barh(y_pos, eu_data, bar_width, left=us_data, color=colors[1], label=labels[1])
ax.barh(
    y_pos,
    china_data,
    bar_width,
    left=[i + j for i, j in zip(us_data, eu_data)],
    color=colors[2],
    label=labels[2],
)
ax.barh(
    y_pos,
    india_data,
    bar_width,
    left=[i + j + k for i, j, k in zip(us_data, eu_data, china_data)],
    color=colors[3],
    label=labels[3],
)
ax.barh(
    y_pos,
    brazil_data,
    bar_width,
    left=[
        i + j + k + l for i, j, k, l in zip(us_data, eu_data, china_data, india_data)
    ],
    color=colors[4],
    label=labels[4],
)

# Labels and Legend
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.set_xticks(np.arange(0, 61, 10))
ax.set_yticks(y_pos)
ax.grid(axis="x", color="gray", linestyle="--", linewidth=0.5)
ax.set_axisbelow(True)
ax.set_yticklabels(categories)
ax.legend(loc="upper center", bbox_to_anchor=(0.5, 1.2), ncols=3)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_249.pdf", bbox_inches="tight")
