
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
category_names = ["Very Satisfied", "Satisfied", "Neutral", "Dissatisfied", "Very Dissatisfied"]
results = {
    "California": [15, 25, 30, 20, 10],
    "Texas": [20, 30, 25, 15, 10],
    "Florida": [10, 15, 30, 25, 20],
    "New York": [5, 10, 25, 30, 30],
    "Pennsylvania": [5, 10, 20, 35, 30],
    "Illinois": [10, 20, 25, 30, 15],
}
xlim = [-90, 90]
xticks = np.arange(-90, 91, 10)
xvline = 0
xlabel = 'Number of Voters'
ylabel = 'States'
title = 'Voter Satisfaction Across Different States'
legend_title = 'Satisfaction Level'

def create_bar_chart(results, category_names):
    fig, ax = plt.subplots(figsize=(10, 6))

    labels = list(results.keys())
    data = np.array(list(results.values()))
    data_cum = data.cumsum(axis=1)
    middle_index = data.shape[1] // 2
    offsets = data[:, range(middle_index)].sum(axis=1) + data[:, middle_index] / 2

    # Color Mapping
    category_colors = plt.get_cmap("coolwarm")(np.linspace(0.15, 0.85, data.shape[1]))

    # Plot Bars
    for i, (colname, color) in enumerate(zip(category_names, category_colors)):
        widths = data[:, i]
        starts = data_cum[:, i] - widths - offsets
        rects = ax.barh(
            labels,
            widths,
            left=starts,
            height=0.5,
            label=colname,
            color=color,
            edgecolor="black",
        )

    # Add Zero Reference Line
    ax.axvline(xvline, linestyle="--", color="black", alpha=0.75)

    # X Axis
    ax.set_xlim(xlim)
    ax.set_xticks(xticks)
    ax.xaxis.set_major_formatter(lambda x, pos: str(abs(int(x))))
    ax.set_xlabel(xlabel, fontsize=12)

    # Y Axis
    ax.set_ylabel(ylabel, fontsize=12)
    ax.invert_yaxis()

    # Remove spines
    ax.spines["right"].set_visible(False)
    ax.spines["top"].set_visible(False)
    ax.spines["left"].set_visible(False)

    # Legend
    ax.legend(
        ncol=len(category_names), bbox_to_anchor=(0.5, 1.2), loc="upper center", title=legend_title
    )

    # Title
    ax.set_title(title, fontsize=14)

    # Set Background Color
    fig.set_facecolor("#FFFFFF")

    return fig, ax


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = create_bar_chart(results, category_names)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_254.pdf", bbox_inches="tight")
