
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.colors as mcolors

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Set the seed for reproducibility
np.random.seed(42)

# Data
categories = [
    "Homework Completion",
    "Quiz Scores",
    "Class Participation",
    "Project Submission",
    "Attendance",
    "Exam Scores",
    "Group Activities",
]
differences = np.random.randint(-80, 81, len(categories))
title = "Relative Difference in Student Performance Categories"
xlabel = "Difference (%)"
ylabel = "Performance Category"
xlim = [-80, 80]
xticks = range(-80, 81, 20)
cbarlabels = ["Below Average", "Above Average"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = [
    (
        plt.cm.Blues(np.array(i) / min(differences))
        if i < 0
        else plt.cm.Oranges(np.array(i) / max(differences))
    )
    for i in differences
]

# Create figure and plot
fig, ax = plt.subplots(figsize=(10, 5))
bars = ax.barh(categories, differences, color=colors, edgecolor='black')

# Set title and labels
ax.set_title(title, fontsize=15)
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)

# Set x-axis limits and labels
ax.set_xlim(xlim)
ax.set_xticks(xticks)
ax.xaxis.grid(True, linestyle='--', linewidth=0.5)

# Add data labels
for bar in bars:
    width = bar.get_width()
    label_x_pos = width - 5 if width < 0 else width + 5
    ax.text(label_x_pos, bar.get_y() + bar.get_height() / 2, f'{width:.0f}%', va='center')

# Create colorbars
cbar1 = plt.colorbar(
    plt.cm.ScalarMappable(norm=mcolors.Normalize(0, 80), cmap="Blues"),
    ax=ax,
    orientation="vertical",
    pad=0.01,
    aspect=20,
)
cbar2 = plt.colorbar(
    plt.cm.ScalarMappable(norm=mcolors.Normalize(0, 80), cmap="Oranges"),
    ax=ax,
    orientation="vertical",
    pad=0.01,
    aspect=20,
)
cbar1.set_label(cbarlabels[0])
cbar2.set_label(cbarlabels[1])

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()

# Save the figure
plt.savefig("bar_256.pdf", bbox_inches="tight")
