
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for the plots
methods = ["Lecture", "Group Work", "Online Learning", "Flipped Classroom", "Project-Based Learning"]
engagement_scores = [5.3, -3.2, 7.8, -1.5, 12.2]

# Axes Limits and Labels
ax_title = "Teaching Methods Effectiveness"
xticks_values = range(-10, 15, 5)
xlabel = "Engagement Score (%)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size to match the original image's dimensions
fig, ax = plt.subplots(figsize=(10, 8))

# Plot for Teaching Methods Effectiveness
bars = ax.barh(methods, engagement_scores, 
               color=["lightgreen" if value > 0 else "lightcoral" for value in engagement_scores], 
               edgecolor="black")

for bar, value in zip(bars, engagement_scores):
    if value < 0:
        bar.set_hatch("\\\\")
        bar.set_edgecolor("darkred")
    else:
        bar.set_edgecolor("green")

ax.set_title(ax_title)

for i, v in enumerate(engagement_scores):
    ax.text(
        v - 0.5 if v < 0 else v + 0.5,
        i,
        f"{v}%",
        color="blue" if v > 0 else "darkred",
        va="center",
        ha="right" if v < 0 else "left",
    )

# Add a vertical line at x=0
ax.axvline(0, color="black")
ax.set_xticks(xticks_values)
# Remove y-axis tick marks
ax.tick_params(axis="y", which="both", left=False)

# Hide all axes except the bottom one
for spine in ["left", "right", "top"]:
    ax.spines[spine].set_visible(False)

# Add x-axis label
ax.set_xlabel(xlabel)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_258.pdf", bbox_inches="tight")

