
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for the plots
materials = ["Silicon", "Cadmium Telluride", "Copper Indium Gallium Selenide", "Perovskite", "Organic Polymer"]
efficiency_changes = [5.3, 2.1, -1.5, 7.8, -3.2]

# Axes Limits and Labels
ax_title = "Efficiency Improvement of Solar Panel Materials"
xticks_values = range(-10, 11, 2)
xlabel = "Efficiency Change (%)"
ylabel = "Solar Panel Materials"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size to match the original image's dimensions
fig, ax = plt.subplots(figsize=(10, 8))

# Plot for Efficiency Improvement
bars = ax.barh(materials, efficiency_changes, color="lightblue", edgecolor="darkblue")
for bar, value in zip(bars, efficiency_changes):
    if value < 0:
        bar.set_hatch("..")
        bar.set_edgecolor("darkred")
ax.set_title(ax_title)
for i, v in enumerate(efficiency_changes):
    ax.text(
        v - 0.3 if v < 0 else v + 0.3,
        i,
        f"{v}%",
        color="darkblue" if v > 0 else "darkred",
        va="center",
        ha="right" if v < 0 else "left",
        fontsize=10,
        fontweight='bold'
    )
# Add a vertical line at x=0
ax.axvline(0, color="black")
ax.set_xticks(xticks_values)
# Remove y-axis tick marks
ax.tick_params(axis="y", which="both", left=False)

# Hide all axes except the bottom one
for spine in ["left", "right", "top"]:
    ax.spines[spine].set_visible(False)

# Add x-axis label
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_259.pdf", bbox_inches="tight")
