
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
categories = ["Voter Turnout", "Campaign Spending", "Social Media Engagement", "Policy Proposals"]
voter_turnout = [600, 750, 830, 690]  # Example data in thousand persons
campaign_spending = [500, 680, 790, 610]  # Example data in millions USD
social_media_engagement = [800, 950, 870, 620]  # Example data in thousand interactions
policy_proposals = [300, 400, 500, 450]  # Example data in number of policies
labels = [
    "Voter Turnout (Thousands)",
    "Campaign Spending (Millions USD)",
    "Social Media Engagement (Thousands)",
    "Policy Proposals",
]
xticks = np.arange(0, 3000, 250)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Stacked Bar Chart
fig, ax = plt.subplots(figsize=(10, 6))
bar_width = 0.5
y_pos = range(len(categories))

ax.barh(
    y_pos,
    voter_turnout,
    bar_width,
    color="#1f77b4",
    edgecolor="#2a3b4d",
    hatch="x",
    label=labels[0],
)
ax.barh(
    y_pos,
    campaign_spending,
    bar_width,
    left=voter_turnout,
    color="#ff7f0e",
    edgecolor="#2a3b4d",
    hatch="o",
    label=labels[1],
)
ax.barh(
    y_pos,
    social_media_engagement,
    bar_width,
    left=[i + j for i, j in zip(voter_turnout, campaign_spending)],
    color="#2ca02c",
    edgecolor="#2a3b4d",
    hatch=".",
    label=labels[2],
)
ax.barh(
    y_pos,
    policy_proposals,
    bar_width,
    left=[i + j + k for i, j, k in zip(voter_turnout, campaign_spending, social_media_engagement)],
    color="#d62728",
    edgecolor="#2a3b4d",
    hatch="/" ,
    label=labels[3],
)

# Labels and Legend
ax.set_xticks(xticks)
ax.set_yticks(y_pos)
ax.grid(axis="x", color="gray", linestyle="--")
ax.set_axisbelow(True)
ax.set_yticklabels(categories)
ax.legend(loc="upper center", bbox_to_anchor=(0.5, 1.2), ncols=4)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_261.pdf", bbox_inches="tight")
