
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
categories = [
    "Team A",
    "Team B",
    "Team C",
    "Team D",
]
goals_scored = [50, 60, 70, 80]  # Example data
assists_made = [30, 45, 40, 50]  # Example data
matches_won = [20, 25, 30, 35]  # Example data
labels = [
    "Goals Scored",
    "Assists Made",
    "Matches Won",
]
xticks = np.arange(0, 200, 20)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Stacked Bar Chart
fig, ax = plt.subplots(figsize=(10, 6))
bar_width = 0.5
y_pos = range(len(categories))

ax.barh(
    y_pos,
    goals_scored,
    bar_width,
    color="#4caf50",
    edgecolor="#2a3b4d",
    hatch="o",
    label=labels[0],
)
ax.barh(
    y_pos,
    assists_made,
    bar_width,
    left=goals_scored,
    color="#2196f3",
    edgecolor="#2a3b4d",
    hatch="x",
    label=labels[1],
)
ax.barh(
    y_pos,
    matches_won,
    bar_width,
    left=[i + j for i, j in zip(goals_scored, assists_made)],
    color="#ff9800",
    edgecolor="#2a3b4d",
    hatch="/",
    label=labels[2],
)

# Labels and Legend
ax.set_xticks(xticks)
ax.set_yticks(y_pos)
ax.grid(axis="x", color="gray", linestyle="--")
ax.set_axisbelow(True)
ax.set_yticklabels(categories)
ax.set_xlabel("Counts")
ax.set_title("Sports Statistics of Different Teams")
ax.legend(loc="upper center", bbox_to_anchor=(0.5, 1.15), ncol=3)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_263.pdf", bbox_inches="tight")
