
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.colors as mcolors

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data
categories = [
    "running",
    "cycling",
    "swimming",
    "weightlifting",
    "yoga",
    "basketball",
    "soccer",
]
synthetic_data = [-10, -15, -20, -5, -8, -12, -7]
human_data = [30, 45, 25, 20, 15, 30, 40]

# Labels and text
chart_title = "Comparison of Exercise Types Between Synthetic and Human Data"
x_label = "Percentage"
labels = ["synthetic data", "human-authored data"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax = plt.subplots(figsize=(8, 8))  # 576x576 pixels

# Define base colors
base_colors = [
    "#76c7c0",
    "#ff6f61",
    "#6b5b95",
    "#88b04b",
    "#f7cac9",
    "#92a8d1",
    "#f4a582",
]

# Generate colors with different saturation
colors_human = base_colors
colors_synthetic = [mcolors.to_rgba(color, alpha=0.6) for color in base_colors]

# Plot horizontal bar chart
ax.barh(categories, synthetic_data, color=colors_synthetic, label=labels[0])
ax.barh(categories, human_data, left=0, color=colors_human, label=labels[1])

# Add data labels inside the bars
for i, (syn_val, hum_val) in enumerate(zip(synthetic_data, human_data)):
    ax.text(syn_val / 2, i, f"{abs(syn_val)}%", va="center", ha="center", color="white")
    ax.text(hum_val / 2, i, f"{hum_val}%", va="center", ha="center", color="white")

# Configuration for axes and labels
ax.set_xlim(min(synthetic_data) - 10, max(human_data) + 10)
ax.set_xlabel(x_label, fontsize=12)
ax.set_title(chart_title, fontsize=14, pad=20)
ax.set_xticks([])
ax.tick_params(axis="y", which="both", left=False)
ax.spines["left"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.spines["top"].set_visible(False)

# Draw a vertical line at x=0
ax.axvline(0, color="black")

# Add text to x=0
ax.text(-4, len(categories), labels[0], ha="right", va="bottom", fontsize=10)
ax.text(4, len(categories), labels[1], ha="left", va="bottom", fontsize=10)

# Invert y-axis
ax.invert_yaxis()

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()

# Save the figure
plt.savefig("bar_264.pdf", bbox_inches="tight")
