
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Sample data for monthly average temperatures in different cities
cities = [
    "New York",
    "Los Angeles",
    "Chicago",
    "Houston",
    "Phoenix",
]
temps_jan = [0.2, 15.3, 5.1, 12.1, 10.0]
temps_apr = [12.4, 18.5, 7.2, 20.4, 23.0]
temps_jul = [25.4, 22.2, 21.1, 29.9, 33.4]
temps_oct = [14.7, 20.3, 10.2, 25.2, 28.9]
labels = ["January", "April", "July", "October"]
xlabel = "Temperature (°C)"
ylabel = "Cities"
title = "Monthly Average Temperatures in Various Cities Over the Year"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Size of the plot
plt.figure(figsize=(10, 8))

# Adjust the position of the bars on the x-axis to prevent overlap
bar_height = 0.15
ind = [i * (bar_height * len(cities)) for i in range(len(temps_jan))]

# Color palette for temperatures
colors = ["#FF6347", "#FFA07A", "#FFD700", "#ADFF2F"]

# Creating the bar plot with adjusted positions to prevent overlap
plt.barh(
    [pos + bar_height * 0 for pos in ind],
    temps_jan,
    color=colors[0],
    height=bar_height,
    label=labels[0],
    edgecolor='black'
)
plt.barh(
    [pos + bar_height * 1 for pos in ind],
    temps_apr,
    color=colors[1],
    height=bar_height,
    label=labels[1],
    edgecolor='black'
)
plt.barh(
    [pos + bar_height * 2 for pos in ind],
    temps_jul,
    color=colors[2],
    height=bar_height,
    label=labels[2],
    edgecolor='black'
)
plt.barh(
    [pos + bar_height * 3 for pos in ind],
    temps_oct,
    color=colors[3],
    height=bar_height,
    label=labels[3],
    edgecolor='black'
)

# X and Y axis Labels
plt.xlabel(xlabel, fontsize=12, fontweight='bold')
plt.ylabel(ylabel, fontsize=12, fontweight='bold')

# Title of the plot
plt.title(title, fontsize=14, fontweight='bold')

# Adding legend
plt.legend()

# Setting the labels for y-axis with adjusted positions
plt.yticks([pos + bar_height * 1.5 for pos in ind], cities)

# Adding grid for better readability
plt.grid(axis='x', linestyle='--', linewidth=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Display the plot with enough space
plt.tight_layout()
plt.savefig("bar_269.pdf", bbox_inches="tight")
