
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Financial data for different metrics across quarters
quarters = ["Q1", "Q2", "Q3", "Q4"]
Revenue = np.array([150, 200, 180, 220]) + np.random.rand(4) * 20  # Revenue in $K
Profit = np.array([40, 60, 55, 70]) + np.random.rand(4) * 10  # Profit in $K
Expenses = np.array([100, 120, 110, 130]) + np.random.rand(4) * 15  # Expenses in $K
Investments = np.array([80, 90, 85, 95]) + np.random.rand(4) * 10  # Investments in $K

labels = ["Revenue ($K)", "Profit ($K)", "Expenses ($K)", "Investments ($K)"]
xlabel = "Amount in $K"
ylabel = "Quarters"
title = "Financial Metrics by Quarter"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Size of the plot
plt.figure(figsize=(10, 7))

# Adjust the position of the bars on the x-axis to prevent overlap
bar_height = 0.3
indices = np.arange(len(Revenue)) * 1.5  # Increase space between groups

# Define some hatch patterns and colors to use for bars
hatch_patterns = ["/", "\\", "|", "-", "+", "*"]
colors = ["#4CAF50", "#2196F3", "#F44336", "#9C27B0"]

# Plot bars for each financial metric
for i, level in enumerate([Revenue, Profit, Expenses, Investments]):
    bars = plt.barh(
        [pos + bar_height * i for pos in indices],
        level,
        color=colors[i],
        height=bar_height,
        hatch=hatch_patterns[i],
        label=f"{labels[i]}",
    )

    # Add text annotations to the right of the bars
    for bar in bars:
        plt.text(
            bar.get_width(),  # X position
            bar.get_y() + bar.get_height() / 2,  # Y position
            f"{bar.get_width():.2f}",  # Text to display
            va="center",
        )

# X and Y axis Labels and limits
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.xlim(
    0,
    max(np.max(Revenue), np.max(Profit), np.max(Expenses), np.max(Investments))
    + 20,
)

# Title of the plot
plt.title(title)

# Adding legend
plt.legend()

# Setting the labels for y-axis with adjusted positions
plt.yticks([pos + bar_height * 1.5 for pos in indices], quarters)

# Adding grids
plt.grid(True, linestyle="--", which="both", axis="x", color="grey", alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Display the plot with enough space
plt.tight_layout()

# Save the plot as a PDF file
plt.savefig("bar_270.pdf", bbox_inches="tight")
