
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Define the categories and scores
categories = ["Healthcare", "Education", "Technology", "Innovation"]
num_scores = 4
score_range = (-100, 0)
scores_gov_investment = np.random.uniform(score_range[0], score_range[1], num_scores).tolist()
scores_public_interest = np.random.uniform(score_range[0], score_range[1], num_scores).tolist()
scores_technology_adv = np.random.uniform(score_range[0], score_range[1], num_scores).tolist()
scores_innovation = np.random.uniform(score_range[0], score_range[1], num_scores).tolist()

# The x locations for the groups
ind = np.arange(len(scores_gov_investment))

# Labels and Plot Types
label_gov_investment = "Government Investments"
label_public_interest = "Public Interest"
label_technology_adv = "Technological Advancements"
label_innovation = "Innovative Initiatives"

# Axes Limits and Labels
xlabel_value = "Impact Score"
ax_title = "Impact Levels by Sector and Initiative"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# The width of the bars
bar_width = 0.2

# Create the figure and axes objects
fig, ax = plt.subplots(figsize=(12, 8))

# Plotting data
bars_gov_investment = ax.barh(
    ind - bar_width * 1.5,
    scores_gov_investment,
    bar_width,
    label=label_gov_investment,
    color="#ff9999",   # Light Red
)
bars_public_interest = ax.barh(
    ind - bar_width * 0.5,
    scores_public_interest,
    bar_width,
    label=label_public_interest,
    color="#66b3ff",   # Light Blue
)
bars_technology_adv = ax.barh(
    ind + bar_width * 0.5,
    scores_technology_adv,
    bar_width,
    label=label_technology_adv,
    color="#99ff99",   # Light Green
)
bars_innovation = ax.barh(
    ind + bar_width * 1.5,
    scores_innovation,
    bar_width,
    label=label_innovation,
    color="#ffcc99",   # Light Orange
)

# Adding text inside the bars
for i, (score_gov, score_pub, score_tech, score_innov) in enumerate(
    zip(scores_gov_investment, scores_public_interest, scores_technology_adv, scores_innovation)
):
    ax.text(
        score_gov,
        i - bar_width * 1.5,
        f"{score_gov:.1f}",
        va="center",
        ha="right",
        color="black",
    )
    ax.text(
        score_pub,
        i - bar_width * 0.5,
        f"{score_pub:.1f}",
        va="center",
        ha="right",
        color="black",
    )
    ax.text(
        score_tech,
        i + bar_width * 0.5,
        f"{score_tech:.1f}",
        va="center",
        ha="right",
        color="black",
    )
    ax.text(
        score_innov,
        i + bar_width * 1.5,
        f"{score_innov:.1f}",
        va="center",
        ha="right",
        color="black",
    )

# Adding labels, title, and custom x-axis tick labels, etc.
ax.set_xlabel(xlabel_value)
ax.set_title(ax_title)
ax.set_yticks(ind)
ax.set_yticklabels(categories)
ax.legend()

# Invert y-axis to have the first entry at the top
plt.gca().invert_yaxis()

# Show grid lines for x-axis
ax.xaxis.grid(True)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_275.pdf", bbox_inches="tight")
