
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt
import colorsys

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Redefining the data for social media platforms
platforms = ["Instagram", "Facebook", "Twitter", "TikTok", "Snapchat", "LinkedIn", "Pinterest"]
active_users = [78.5, 65.3, 55.2, 85.0, 48.1, 40.7, 35.2]  # in percentages

# Sorting the data in descending order while keeping track of the platforms order
sorted_data = sorted(zip(active_users, platforms), reverse=True)
sorted_active_users, sorted_platforms = zip(*sorted_data)

title = "Monthly Active Users on Social Media Platforms"
xlabel = "Platform"
ylabel = "Percentage of Active Users (%)"
ylim = [0, np.max(sorted_active_users) + 10]

# Generate random colors with lower saturation
def hsl_to_rgb(h, s, l):
    return colorsys.hls_to_rgb(h, l, s)


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and bar chart with the sorted data
plt.figure(figsize=(12, 8))
# Randomly generate colors
colors = [hsl_to_rgb(hue, 0.5, 0.6) for hue in np.linspace(0, 1, len(platforms) + 1)[:-1]]

bars = plt.bar(sorted_platforms, sorted_active_users, color=colors)

# Adding data labels to each bar
for bar in bars:
    yval = bar.get_height()
    text_y = yval - 5 if yval > 10 else yval + 1  # Slight modification to avoid negative values
    plt.text(bar.get_x() + bar.get_width() / 2, text_y, f"{yval}%", ha="center", va="top" if text_y < yval else "bottom")

# Set chart title and labels
plt.title(title)
plt.xlabel(xlabel)
plt.ylabel(ylabel)

# Randomly set y-axis range to a bit higher than the max value
plt.ylim(ylim)

# Randomize the gridlines and ticks
plt.grid(axis="y", linestyle="--", alpha=0.7)

# Randomize tick rotation
plt.xticks(rotation=45)

# Hide the top and right spines
plt.gca().spines["top"].set_visible(False)
plt.gca().spines["right"].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
# Apply tight layout
plt.tight_layout()

plt.savefig("bar_279.pdf", bbox_inches="tight")
