
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Example geographical data
categories = [
    "Mountains",
    "Rivers",
    "Cities",
    "Forests",
]
layer_data = {
    "Elevation": np.array([700, 600, 650, 500]),
    "Water Bodies": np.array([500, 700, 700, 600]),
    "Population Density": np.array([400, 600, 550, 600]),
    "Vegetation": np.array([800, 500, 500, 700]),
}

title = "Stacked Bar Chart of Geographical Features"
xlabel = "Geographical Aspects"
ylabel = "Values"

# Colors for each layer (earth-toned palette)
colors = ["#4c9f70", "#88c999", "#d9f2d4", "#116611"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================

# Create the figure and axes objects
fig, ax = plt.subplots(figsize=(10, 6))

# Variables to store the bottom position for each stack
bottoms = np.array([0] * len(categories))

for i, (layer, values) in enumerate(layer_data.items()):
    bars = ax.bar(categories, values, bottom=bottoms, color=colors[i], label=layer)

    # Add data labels on each bar
    for bar, bottom in zip(bars, bottoms):
        height = bar.get_height()
        ax.text(
            bar.get_x() + bar.get_width() / 2,
            bottom + height / 2,
            str(height),
            ha="center",
            va="center",
            color="white",
        )

    # Update the bottoms position
    bottoms += values

# Chart title and labels
plt.title(title)
plt.xlabel(xlabel)
plt.ylabel(ylabel)

# Adding gridlines for better readability
ax.yaxis.grid(True)

# Adding legend
plt.legend()

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
# Save the plot as PDF
plt.savefig("bar_284.pdf", bbox_inches="tight")
