
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Sample data
critics = ["Alice", "Bob", "Charlie", "David", "Eve", "Frank"]
scores = {
    "Alice": [15, 20, 18, 25, 22],
    "Bob": [10, 15, 25, 18, 20],
    "Charlie": [18, 22, 20, 15, 17],
    "David": [25, 18, 15, 20, 22],
    "Eve": [20, 25, 18, 15, 17],
    "Frank": [17, 15, 20, 25, 18],
}

title = "Literary Work Critique Scores"
xlabel = "Critic"
ylabel = "Scores"
ylim = [0, 100]
yticks = range(0, 101, 20)
score_labels = [f"Work {i+1}" for i in range(5)]
legendtitle = "Literary Works"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Define a color map for gradients
cmap = plt.get_cmap("viridis")

fig, ax = plt.subplots(figsize=(10, 6))  # Adjusting figure size

for i, critic in enumerate(critics):
    bottom = 0
    score_list = scores[critic]
    for j, score in enumerate(score_list):
        color = cmap(
            1 - j / len(score_list)
        )  # Determine color based on position in list
        bar = ax.bar(critic, score, bottom=bottom, color=color)
        bottom += score
        # Annotate each segment
        if j == len(score_list) - 1:
            ax.text(
                bar[0].get_x() + bar[0].get_width() / 2,
                bottom - score / 2,
                str(score),
                ha="center",
                va="bottom",
                color="black",
            )
        else:
            ax.text(
                bar[0].get_x() + bar[0].get_width() / 2,
                bottom - score / 2,
                str(score),
                ha="center",
                va="center",
                color="white",
            )

# Adding title and labels
ax.set_title(title)
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_ylim(ylim)  # Adjusting limit to make space for text annotations
ax.set_yticks(yticks)

# Adding legend with score indications
ax.legend(score_labels, title=legendtitle, bbox_to_anchor=(1.05, 1), loc="upper left")
ax.yaxis.grid(linestyle="--")

ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_290.pdf", bbox_inches="tight")
