
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data
import numpy as np

np.random.seed(42)

# Categories related to transportation
categories = ["Car", "Bus", "Bicycle", "Train", "Airplane", "Boat"]

# Generate three lists representing different optimization strategies
FuelEfficiency, CostEfficiency, TimeEfficiency = np.random.dirichlet(np.ones(3), size=len(categories)).T

FuelEfficiency = FuelEfficiency * 100
CostEfficiency = CostEfficiency * 100
TimeEfficiency = TimeEfficiency * 100

# Text labels
xlabel = "Transportation Methods"
ylabel = "Optimization Percentage"
title = "Optimization Distribution Across Transportation Methods"
supertitle = "Comparison of Fuel, Cost, and Time Efficiency"
legendlabels = ["Fuel Efficiency", "Cost Efficiency", "Time Efficiency"]

yticks = np.arange(0, 101, 20)
ylim = [0, 100]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Stacked bar chart setup
bar_width = 0.8
r = np.arange(len(categories))

# Color scheme for transportation
colors = ["#1f77b4", "#ff7f0e", "#2ca02c"]

# Plot
fig, ax = plt.subplots(figsize=(10, 6))
bar1 = ax.bar(
    r,
    FuelEfficiency,
    color=colors[0],
    edgecolor="white",
    hatch="//",
    width=bar_width,
    label=legendlabels[0],
)
bar2 = ax.bar(
    r,
    CostEfficiency,
    bottom=FuelEfficiency,
    color=colors[1],
    edgecolor="white",
    hatch="\\\\",
    width=bar_width,
    label=legendlabels[1],
)
bar3 = ax.bar(
    r,
    TimeEfficiency,
    bottom=FuelEfficiency + CostEfficiency,
    color=colors[2],
    edgecolor="white",
    hatch="..",
    width=bar_width,
    label=legendlabels[2],
)

# Titles and labels
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
fig.suptitle(supertitle, fontsize=14)

# Setting the ticks and labels
ax.set_xticks(r)
ax.set_xticklabels(categories, rotation=-45, ha="left")
ax.set_yticks(yticks)
ax.set_ylim(ylim)
ax.set_yticklabels(["{}%".format(i) for i in yticks])

# Adding legend
ax.legend(loc="upper center", bbox_to_anchor=(0.5, 1.15), ncol=3)

# Styling the plot
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.spines["left"].set_visible(False)
ax.spines["bottom"].set_visible(False)

# Grid lines
ax.yaxis.grid(True, linestyle="--", color="gray")

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("bar_291.pdf", bbox_inches="tight")
