
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
campaigns = ["Campaign A", "Campaign B", "Campaign C", "Campaign D", "Campaign E"]
improvements = {"USA": [2.5], "Germany": [3.2], "France": [1.8], "Italy": [2.9], "Spain": [3.4]}

xlabel = "Campaign"
ylabel = "Tourist Increase [%]"
ylim = [0, 4]
legendtitle = "Country"
title = "Tourism Campaign Effectiveness by Country"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Colors for each country
colors = ["#ff9999", "#66b3ff", "#99ff99", "#ffcc99", "#c2c2f0"]

# Figure and axis
fig, ax = plt.subplots(figsize=(10, 6))

# Bar width
bar_width = 0.75

# Positions of the bars on the x-axis
r = np.arange(len(campaigns))

# Plotting the bars
for i, country in enumerate(improvements):
    bars = plt.bar(
        r[i],
        improvements[country],
        color=colors[i],
        width=bar_width,
        label=country,
        hatch="\\",
        edgecolor="white",
    )
    # Add text labels
    for bar, val in zip(bars, improvements[country]):
        height = bar.get_height()
        ax.text(
            bar.get_x() + bar.get_width() / 2,
            height + 0.1 if height > 0 else height - 0.4,
            f"{val:.1f}",
            ha="center",
        )

# Add xticks on the middle of the group bars
plt.xlabel(xlabel)
plt.xticks(r, campaigns, rotation=45)

# Add ylabel
plt.ylabel(ylabel)
plt.ylim(ylim)

plt.gca().grid(color="gray", linewidth=0.5, linestyle='--')
plt.gca().set_axisbelow(True)

# Create legend & Show graphic
plt.legend(title=legendtitle, loc="upper left")
plt.title(title)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_294.pdf", bbox_inches="tight")
