
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
schools = ["Stoicism", "Existentialism", "Analytic Philosophy", "Pragmatism", "Phenomenology"]
interest_increase = {"Stoicism": [2.5], "Existentialism": [3.0], "Analytic Philosophy": [1.8], "Pragmatism": [2.9], "Phenomenology": [1.5]}

xlabel = "Philosophical School"
ylabel = "Interest Increase [%]"
ylim = [0, 4]
legendtitle = "Philosophical School"
title = "Increase in Public Interest by Philosophical School"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Colors for each school of thought
colors = ["#4c72b0", "#55a868", "#c44e52", "#8172b3", "#ccb974"]

# Figure and axis
fig, ax = plt.subplots(figsize=(10, 6))

# Bar width
bar_width = 0.75

# Positions of the bars on the x-axis
r = np.arange(len(schools))

# Plotting the bars
for i, school in enumerate(interest_increase):
    bars = plt.bar(
        r[i],
        interest_increase[school],
        color=colors[i],
        width=bar_width,
        label=school,
        hatch="//",
        edgecolor="white",
    )
    # Add text labels
    for bar, val in zip(bars, interest_increase[school]):
        height = bar.get_height()
        ax.text(
            bar.get_x() + bar.get_width() / 2,
            height + 0.1 if height > 0 else height - 0.4,
            f"{val:.1f}",
            ha="center",
        )

# Add xticks on the middle of the group bars
plt.xlabel(xlabel)
plt.xticks(r, schools, rotation=45)

# Add ylabel
plt.ylabel(ylabel)
plt.ylim(ylim)

plt.gca().grid(color="gray", linewidth=0.5)
plt.gca().set_axisbelow(True)

# Create legend & Show graphic
plt.legend(title=legendtitle, loc="upper right")
plt.title(title)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_295.pdf", bbox_inches="tight")
