
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Seed for reproducibility
np.random.seed(42)

# Data
programs = ["Weight Loss", "Cholesterol Control", "Cardio Health", "Mental Wellness", "General Fitness"]
improvements = {"BMI": [4.5], "Cholesterol": [3.0], "Heart Rate": [2.8], "Stress Level": [5.0], "Endurance": [3.5]}

xlabel = "Health Programs"
ylabel = "Improvement [%]"
ylim = [0, 6]
legendtitle = "Health Metrics"
title = "Health Program Performance Improvements"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Colors for each metric
colors = ["#2E8B57", "#4682B4", "#3CB371", "#20B2AA", "#2E8B57"]

# Figure and axis
fig, ax = plt.subplots(figsize=(10, 6))

# Bar width
bar_width = 0.75

# Positions of the bars on the x-axis
r = np.arange(len(programs))

# Plotting the bars
for i, metric in enumerate(improvements):
    bars = plt.bar(
        r[i],
        improvements[metric],
        color=colors[i],
        width=bar_width,
        label=metric,
        edgecolor="white",
    )
    # Add text labels
    for bar, val in zip(bars, improvements[metric]):
        height = bar.get_height()
        ax.text(
            bar.get_x() + bar.get_width() / 2,
            height + 0.1 if height > 0 else height - 0.4,
            f"{val:.1f}",
            ha="center",
        )

# Add xticks on the middle of the group bars
plt.xlabel(xlabel)
plt.xticks(r, programs, rotation=45)

# Add ylabel
plt.ylabel(ylabel)
plt.ylim(ylim)

# Grid settings
plt.gca().grid(color="gray", linewidth=0.5)
plt.gca().set_axisbelow(True)

# Create legend & Show graphic
plt.legend(title=legendtitle, loc="upper right")
plt.title(title)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_296.pdf", bbox_inches="tight")
