
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Set a seed for reproducibility

# Define matches
matches = np.array([1, 2, 3, 4, 5])

# Generate synthetic scores for two teams
avg_scores_team_a = np.random.normal(75, 10, 5)  # Example average scores for Team A
avg_scores_team_b = np.random.normal(80, 15, 5)  # Example average scores for Team B

labels = ["Team A", "Team B"]
axline = 0
xlabel = "Matches"
ylabel = "Average Score"
ylim = [0, 120]
yticks = np.arange(0, 130, 10)
title = "Average Scores per Match for Team A and Team B"
legend_labels = ["Team A", "Team B"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and subplots
fig, axs = plt.subplots(figsize=(10, 5))
width = 0.4

# Plotting bars for each team
bars1 = axs.bar(
    matches - width / 2,
    avg_scores_team_a,
    width=width,
    color="#1f77b4",  # Blue color for Team A
    edgecolor="black",
    label="Team A",
)
bars2 = axs.bar(
    matches + width / 2,
    avg_scores_team_b,
    width=width,
    color="#ff7f0e",  # Orange color for Team B
    edgecolor="black",
    label="Team B",
)

# Adding text labels on the bars
for bars in [bars1, bars2]:
    for bar in bars:
        height = bar.get_height()
        axs.text(
            bar.get_x() + bar.get_width() / 2,
            height,
            f"{height:.1f}",
            ha="center",
            va="bottom" if height > 0 else "top",
        )

# Additional plot settings
axs.axhline(axline, color="black")
axs.set_xlabel(xlabel, fontsize=14)
axs.set_ylabel(ylabel, fontsize=14)
axs.set_ylim(ylim)
axs.set_yticks(yticks)
axs.set_xticks(matches)
axs.yaxis.grid(True)
axs.set_axisbelow(True)

# Adding title and legend
axs.set_title(title, fontsize=16)
plt.legend(loc="upper center", bbox_to_anchor=(0.5, 1.2), ncol=2, fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
# Save the figure as a PDF
plt.tight_layout()
plt.savefig("bar_298.pdf", bbox_inches="tight")
