
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Set a seed for reproducibility

# Define fiscal quarters
quarters = np.array([1, 2, 3, 4, 5])

# Generate synthetic passenger number changes for two historical railway lines
railway_changes_line_a = np.random.uniform(-10, 10, 5)  # Railway Line A
railway_changes_line_b = np.random.uniform(-10, 10, 5)  # Railway Line B

# Chart text settings
labels = ["Railway Line A", "Railway Line B"]
axline = 0
xlabel = "Fiscal Quarter"
ylabel = "Passenger Change (%)"
ylim = [-10, 10]
yticks = np.arange(-10, 11, 5)
title = "Historical Railway Passenger Trends"
subtitle = "Changes in Passenger Numbers Across Fiscal Quarters"
legend_labels = ["Railway Line A", "Railway Line B"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and subplots
fig, axs = plt.subplots(figsize=(10, 5))
width = 0.4

# Plotting bars for each railway line
bars1 = axs.bar(
    quarters - width / 2,
    railway_changes_line_a,
    width=width,
    color="#8B4513",  # SaddleBrown for Railway Line A
    label=legend_labels[0],
)
bars2 = axs.bar(
    quarters + width / 2,
    railway_changes_line_b,
    width=width,
    color="#A0522D",  # Sienna for Railway Line B
    label=legend_labels[1],
)

# Adding text labels on the bars
for bars in [bars1, bars2]:
    for bar in bars:
        height = bar.get_height()
        axs.text(
            bar.get_x() + bar.get_width() / 2,
            height,
            f"{height:.1f}",
            ha="center",
            va="bottom" if height > 0 else "top",
        )

# Additional plot settings
axs.axhline(axline, color="black", linestyle='--', linewidth=0.8)
axs.set_xlabel(xlabel, fontsize=12)
axs.set_ylabel(ylabel, fontsize=12)
axs.set_ylim(ylim)
axs.set_yticks(yticks)
axs.set_xticks(quarters)
axs.yaxis.grid(True, linestyle=':', linewidth=0.5)
axs.set_axisbelow(True)

# Adding titles and legend
axs.set_title(subtitle, fontsize=14, pad=20)
fig.suptitle(title, fontsize=16, fontweight='bold')
plt.legend(loc="upper center", bbox_to_anchor=(0.5, 1.10), ncol=2)

# ===================
# Part 4: Saving Output
# ===================
# Save the figure as a PDF
plt.tight_layout(rect=[0, 0, 1, 0.95])  # Adjust layout to make space for the titles
plt.savefig("bar_299.pdf", bbox_inches="tight")
