
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)

# Data for the bar charts
region_a_population = [25.3, 35.8, 20.4, 18.5]
region_b_population = [22.1, 30.7, 25.0, 22.2]
x = np.arange(len(region_a_population))  # x-coordinates for the bars
labels = ["Region A Population", "Region B Population"]  # Labels for the legend
title = "Population Distribution by Age Group"  # Title for the plot
xlabel = "Age Groups"
age_groups = ["0-18", "19-35", "36-50", "51+"]
ylim1 = [0, 40]  # y-axis limits for the first subplot
ylim2 = [0, 40]  # y-axis limits for the second subplot
yticks1 = [0, 10, 20, 30, 40]  # y-ticks for the first subplot
yticks2 = [0, 10, 20, 30, 40]  # y-ticks for the second subplot

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size to match the original image's dimensions
fig, ax1 = plt.subplots(figsize=(8, 6))

# Create the first subplot for 'region_a_population' using the left y-axis
ax1.bar(
    x - 0.2,
    region_a_population,
    width=0.4,
    label=labels[0],
    color="#2a9d8f",
    align="center",
)
ax1.set_ylabel(labels[0], color="#2a9d8f")
ax1.tick_params(axis="y", labelcolor="#2a9d8f")

# Create the second y-axis for 'region_b_population'
ax2 = ax1.twinx()
ax2.bar(
    x + 0.2,
    region_b_population,
    width=0.4,
    label=labels[1],
    color="#e76f51",
    align="center",
)
ax2.set_ylabel(labels[1], color="#e76f51")
ax2.tick_params(axis="y", labelcolor="#e76f51")

# Title for the plot
ax1.set_title(title)

# Set x-axis labels
ax1.set_xticks(x)
ax1.set_xticklabels(age_groups)
ax1.set_xlabel(xlabel)

# Drawing a horizontal line at y=0 (if required, but not usually necessary for positive population data)

# Annotate bars with their values
for j in range(len(region_a_population)):
    ax1.text(
        x[j] - 0.2,
        region_a_population[j] + 1,
        f"{region_a_population[j]}%",
        ha="center",
        color="black",
    )
    ax2.text(
        x[j] + 0.2,
        region_b_population[j] + 1,
        f"{region_b_population[j]}%",
        ha="center",
        color="black",
    )

ax1.set_ylim(ylim1)
ax1.set_yticks(yticks1)

ax2.set_ylim(ylim2)
ax2.set_yticks(yticks2)
ax2.set_yticklabels(yticks2)
# Add legend to the subplot
ax1.legend(loc="upper left", bbox_to_anchor=(0.0, 1.15))
ax1.grid(axis="y", linestyle="--")
ax1.set_axisbelow(True)
ax2.legend(loc="upper right", bbox_to_anchor=(1.0, 1.15))
ax2.grid(axis="y", linestyle="--")
ax2.set_axisbelow(True)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout()
plt.savefig("bar_304.pdf", bbox_inches="tight")
