
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for the bar charts
average_speed = [60, 45, 80, 20]  # average speed in km/h
fuel_consumption = [8, 25, 5, 0]  # fuel consumption in L/100km

x = np.arange(len(average_speed))  # x-coordinates for the bars
transport_modes = ["Car", "Bus", "Train", "Bicycle"]  # x-labels for the bars
labels = ["Average Speed (km/h)", "Fuel Consumption (L/100km)"]  # Labels for the legend
title = "Transportation Analysis"  # Title for the plot
ylim1 = [-100, 100]  # y-axis limits for the first subplot
ylim2 = [-30, 30]  # y-axis limits for the second subplot
yticks1 = [0, 20, 40, 60, 80, 100]  # y-ticks for the first subplot
yticks2 = [-30, -20, -10, 0]  # y-ticks for the second subplot

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size to match the original image's dimensions
fig, ax1 = plt.subplots(figsize=(8, 6))

# Create the first subplot for 'average_speed' using the left y-axis
ax1.bar(
    x,
    average_speed,
    width=0.4,
    label=labels[0],
    color="#76b7b2",
    align="center",
)
ax1.set_ylabel(labels[0], color="#76b7b2")
ax1.tick_params(axis="y", labelcolor="#76b7b2")

# Create the second y-axis for 'fuel_consumption'
ax2 = ax1.twinx()
ax2.bar(
    x,
    [-i for i in fuel_consumption],
    width=0.4,
    label=labels[1],
    color="#ff9da7",
    align="center",
)
ax2.set_ylabel(labels[1], color="#ff9da7")
ax2.tick_params(axis="y", labelcolor="#ff9da7")

# Title for the plot
ax1.set_title(title)

# Set x-axis labels
ax1.set_xticks(x)
ax1.set_xticklabels(transport_modes)

# Drawing a horizontal line at y=0
ax1.axhline(0, color="black", linewidth=0.8)

# Annotate bars with their values
for j in range(4):
    ax1.text(
        x[j],
        average_speed[j] + 2,
        f"{average_speed[j]} km/h",
        ha="center",
        color="white",
    )
    ax2.text(
        x[j],
        -fuel_consumption[j] - 3,
        f"{fuel_consumption[j]} L/100km",
        ha="center",
        color="#ff9da7",
    )

ax1.set_ylim(ylim1)
ax1.set_yticks(yticks1)

ax2.set_ylim(ylim2)
ax2.set_yticks(yticks2)
ax2.set_yticklabels(yticks2)
# Add legend to the subplot
ax1.legend(loc="upper left", bbox_to_anchor=(0.0, 1.2))
ax1.grid(axis="y", linestyle="--")
ax1.set_axisbelow(True)
ax2.legend(loc="upper right", bbox_to_anchor=(1, 1.2))
ax2.grid(axis="y", linestyle="--")
ax2.set_axisbelow(True)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout()
plt.savefig("bar_305.pdf", bbox_inches="tight")

