
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Generate example data related to different artistic disciplines
categories = ["Sculpture", "Painting", "Digital Art", "Performance Art"]

# Data for the graph: budgets for the current and previous years (in thousands of dollars)
values1_A = [np.random.uniform(300, 1000) for _ in categories]  # Current Year
values2_A = [np.random.uniform(300, 1000) for _ in categories]  # Previous Year
labels = ["Current Year", "Previous Year"]
xlabel = "Artistic Disciplines"
ylabel = "Budget (thousands of dollars)"
title = "Annual Budget Allocation by Discipline"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set up the figure size
fig, ax = plt.subplots(figsize=(10, 6))

# Make the bar plot with hatch patterns and new colors
ax.bar(
    categories,
    values1_A,
    color="#ff9999",
    hatch="/",
    label="Current Year",
    edgecolor="black",
)
ax.bar(
    categories,
    values2_A,
    color="#66b3ff",
    hatch="\\",
    label="Previous Year",
    bottom=values1_A,
    edgecolor="black",
)

# Labeling and customizing
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)
plt.legend()

# Adding grid lines for better readability
plt.grid(axis="y", linestyle="--", alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and display
plt.tight_layout()

# Save the plot as a PDF file
plt.savefig("bar_307.pdf", bbox_inches="tight")
