
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Generate some example communication data
categories = ["Email", "Phone", "Social Media", "Face-to-Face"]

# Data for the graph: positive values for interaction counts (in thousands)
values1_A = [np.random.uniform(50, 200) for _ in categories]  # Current Year
values2_A = [np.random.uniform(50, 200) for _ in categories]  # Previous Year
labels = ["Current Year", "Previous Year"]
xlabel = "Communication Channels"
ylabel = "Interaction Counts (thousands)"
title = "Communication Interactions by Channel"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set up the figure size
fig, ax = plt.subplots(figsize=(10, 6))

# Make the bar plot with hatch patterns
ax.bar(
    categories,
    values1_A,
    color="lightblue",
    hatch="/",
    label="Current Year",
    edgecolor="navy",
)
ax.bar(
    categories,
    values2_A,
    color="salmon",
    hatch="\\",
    label="Previous Year",
    bottom=values1_A,
    edgecolor="darkred",
)

# Labeling and customizing
plt.xlabel(xlabel, fontsize=12)
plt.ylabel(ylabel, fontsize=12)
plt.title(title, fontsize=14)
plt.legend()

# Adding grid lines for better readability
plt.grid(axis="y", linestyle="--", alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and display
plt.tight_layout()

# Save the plot as a PDF file
plt.savefig("bar_308.pdf", bbox_inches="tight")
