
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data points representing energy usage in four regions
x = np.arange(4)  # X-axis points represent different regions
y1 = np.array([220, 200, 210, 190])  # Energy usage levels for 2020
y2 = np.array([210, 190, 200, 180])  # Energy usage levels for 2021
labels = ["2020 Energy Usage", "2021 Energy Usage"]
xticklabels = ["Region 1", "Region 2", "Region 3", "Region 4"]
title = "Annual Energy Usage Reductions"
ylim1 = [0, 250]
ylim2 = [0, 250]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax1 = plt.subplots(figsize=(10, 5))
width = 0.35  # Width of the bars

# Plotting data for the year 2020
ax1.bar(
    x,
    y1,
    color="#76c7c0",
    hatch="/",
    width=width,
    label=labels[0],
    edgecolor="black",
)

# Create a second y-axis sharing the same x-axis
ax2 = ax1.twinx()
ax2.bar(
    x + width,
    y2,
    color="#ffb3b3",
    hatch="\\",
    width=width,
    label=labels[1],
    edgecolor="black",
)

# Set the x-ticks to be in the middle of the two bars and add labels for the regions
ax1.set_xticks(x + width / 2)
ax1.set_xticklabels(xticklabels)

# Adding legends to the plot
ax1.legend(loc="upper left")
ax2.legend(loc="upper right")

# Labeling y-axes
ax1.set_ylabel(labels[0], color="#348888")
ax2.set_ylabel(labels[1], color="#b84242")

# Setting colors for y-axis
ax1.tick_params(axis="y", colors="#348888")
ax2.tick_params(axis="y", colors="#b84242")

# Setting the limits for y-axes
ax1.set_ylim(ylim1)
ax2.set_ylim(ylim2)

# Title for the chart
plt.title(title)

# ===================
# Part 4: Saving Output
# ===================
# Layout adjustment to prevent clipping
plt.tight_layout()

# Saving the plot as a PDF
plt.savefig("bar_313.pdf", bbox_inches="tight")
