
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)
# Data points representing annual sales for different technology products
x = np.arange(4)  # X-axis points represent different products
y1 = np.array([250, 300, 350, 400])  # Sales for 2021
y2 = np.array([300, 350, 400, 450])  # Sales for 2022
labels = ["2021 Sales", "2022 Sales"]
xticklabels = ["Product A", "Product B", "Product C", "Product D"]
title = "Annual Technology Product Sales"
ylim1 = [0, 500]
ylim2 = [0, 500]  # Both y-axis limits are the same for better comparison

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax1 = plt.subplots(figsize=(10, 5))
width = 0.4  # Width of the bars

# Plotting data for the year 2021
ax1.bar(
    x,
    y1,
    color="#66c2a5",
    hatch="o",
    width=width,
    label=labels[0],
    edgecolor="black",
)

# Create a second y-axis sharing the same x-axis
ax2 = ax1.twinx()
ax2.bar(
    x + width,
    y2,
    color="#fc8d62",
    hatch="x",
    width=width,
    label=labels[1],
    edgecolor="black",
)

# Set the x-ticks to be in the middle of the two bars and add labels for the products
ax1.set_xticks(x + width / 2)
ax1.set_xticklabels(xticklabels)

# Adding legends to the plot
ax1.legend(loc="upper left")
ax2.legend(loc="upper right")

# Labeling y-axes
ax1.set_ylabel(labels[0], color="#1b7837")
ax2.set_ylabel(labels[1], color="#e66101")

# Setting colors for y-axis
ax1.tick_params(axis="y", colors="#1b7837")
ax2.tick_params(axis="y", colors="#e66101")

# Setting the limits for y-axes
ax1.set_ylim(ylim1)
ax2.set_ylim(ylim2)

# Title for the chart
plt.title(title)

# ===================
# Part 4: Saving Output
# ===================
# Layout adjustment to prevent clipping
plt.tight_layout()

# Saving the plot as a PDF
plt.savefig("bar_314.pdf", bbox_inches="tight")
