
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Example data
groups = ["Q1", "Q2", "Q3", "Q4"]
roi_company_a = [7, 8.5, 9.2, 10]
roi_company_b = [6, 7.8, 8.1, 9.5]
profit_margin_a = [12, 13.5, 14, 15]
profit_margin_b = [10, 11, 11.5, 12]

n_groups = len(groups)

labels = ["ROI Company A", "ROI Company B", "Profit Margin A", "Profit Margin B"]
xlabel = "Quarter"
ylabel = "Percentage"
title = "Financial Performance Over Four Quarters"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(10, 5))

index = np.arange(n_groups)
bar_width = 0.2

opacity = 0.8

rects1 = ax.bar(
    index - 1.5 * bar_width,
    roi_company_a,
    bar_width,
    alpha=opacity,
    color="#2A9D8F",  # Teal
    label=labels[0],
)

rects2 = ax.bar(
    index - 0.5 * bar_width,
    roi_company_b,
    bar_width,
    alpha=opacity,
    color="#264653",  # Dark Blue
    label=labels[1],
)

rects3 = ax.bar(
    index + 0.5 * bar_width,
    profit_margin_a,
    bar_width,
    alpha=opacity,
    color="#E9C46A",  # Yellow
    label=labels[2],
)

rects4 = ax.bar(
    index + 1.5 * bar_width,
    profit_margin_b,
    bar_width,
    alpha=opacity,
    color="#F4A261",  # Orange
    hatch="x",
    label=labels[3],
)

ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.set_xticks(index)
ax.set_xticklabels(groups)
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.yaxis.grid(True, linestyle="--")
plt.legend()

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_318.pdf", bbox_inches="tight")
