
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Data
N = 5
stress_levels = (1.2, 2.4, 3.1, 4.0, 3.6)
happiness_levels = (3.5, 3.0, 2.5, 2.0, 2.7)
productivity_levels = (4.0, 3.8, 3.2, 2.8, 3.1)

# Age groups
ind = np.arange(N)  # the x locations for the groups
width = 0.25  # the width of the bars

# Axes Limits and Labels
ylabel_value = "Average Score"
xlabel_value = "Age Groups"
legend_labels = (
    "Stress Levels",
    "Happiness Levels",
    "Productivity Levels",
)
title_value = "Psychological Metrics Across Age Groups"
age_group_labels = ("18-25", "26-35", "36-45", "46-55", "56+")


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig = plt.figure(figsize=(10, 7))
ax = fig.add_subplot(111)
colors = (
    "#4F6272",  # Stress Levels
    "#8CB369",  # Happiness Levels
    "#EFC050",  # Productivity Levels
)
rects1 = ax.bar(ind, stress_levels, width, color=colors[0])
rects2 = ax.bar(ind + width, happiness_levels, width, color=colors[1])
rects3 = ax.bar(ind + 2 * width, productivity_levels, width, color=colors[2])

ax.set_ylabel(ylabel_value)
ax.set_xlabel(xlabel_value)
ax.set_title(title_value)
ax.set_xticks(ind + width)
ax.set_xticklabels(age_group_labels)

ax.legend(
    (rects1[0], rects2[0], rects3[0]),
    legend_labels,
)

ax.grid(True, linestyle='--', linewidth=0.5, axis='y')

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_81.pdf", bbox_inches="tight")
