
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Sample data
time = np.arange(0, 45, 5)
electronics = np.array([0.4, 0.45, 0.48, 0.5, 0.46, 0.44, 0.42, 0.45, 0.47])
clothing = np.array([0.2, 0.25, 0.23, 0.22, 0.24, 0.22, 0.25, 0.24, 0.22])
groceries = np.array([0.15, 0.1, 0.12, 0.1, 0.11, 0.12, 0.12, 0.11, 0.10])
furniture = np.array([0.1, 0.12, 0.1, 0.08, 0.1, 0.11, 0.12, 0.1, 0.08])
toys = np.array([0.15, 0.08, 0.07, 0.1, 0.09, 0.11, 0.09, 0.1, 0.13])
width = 2

barlabel = ["Electronics", "Clothing", "Groceries", "Furniture", "Toys"]
xlabel = "Time (Months)"
ylabel = "Sales Percentage"
title = "Sales Distribution Over Time"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xticks = [0, 10, 20, 30, 40]

# Stacked bar chart
plt.figure(figsize=(8, 4))
plt.bar(time, electronics, width, color="#1f77b4", label=barlabel[0])
plt.bar(time, clothing, width, bottom=electronics, color="#ff7f0e", label=barlabel[1])
plt.bar(time, groceries, width, bottom=electronics + clothing, color="#2ca02c", label=barlabel[2])
plt.bar(time, furniture, width, bottom=electronics + clothing + groceries, color="#d62728", label=barlabel[3])
plt.bar(time, toys, width, bottom=electronics + clothing + groceries + furniture, color="#9467bd", label=barlabel[4])

# Labels and title
plt.xticks(xticks)
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)

# Legend
plt.legend(loc="upper right", bbox_to_anchor=(1.25, 1))

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_84.pdf", bbox_inches="tight")
