
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Sample data
time = np.arange(0, 45, 5)
company_a = np.array([20, 15, 30, 35, 40, 55, 60, 65, 70])
company_b = np.array([10, 15, 10, 5, 5, 10, 5, 10, 5])
company_c = np.array([5, 10, 5, 10, 5, 5, 10, 5, 5])
company_d = np.array([40, 30, 30, 30, 20, 10, 10, 10, 10])
others = np.array([25, 30, 25, 20, 30, 20, 15, 10, 10])
width = 2

barlabel = ["Company A", "Company B", "Company C", "Company D", "Others"]
xlabel = "Time (Months)"
ylabel = "Market Share (%)"
title = "Market Share Distribution Over Time"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xticks = [0, 10, 20, 30, 40]

# Stacked bar chart
plt.figure(figsize=(10, 6))  # Adjusting figure size for better visibility
plt.bar(time, company_a, width, color="#1f77b4", label=barlabel[0])
plt.bar(time, company_b, width, bottom=company_a, color="#ff7f0e", label=barlabel[1])
plt.bar(time, company_c, width, bottom=company_a + company_b, color="#2ca02c", label=barlabel[2])
plt.bar(time, company_d, width, bottom=company_a + company_b + company_c, color="#d62728", label=barlabel[3])
plt.bar(time, others, width, bottom=company_a + company_b + company_c + company_d, color="#9467bd", label=barlabel[4])

# Labels and title
plt.xticks(xticks)
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)

# Legend
plt.legend(loc="upper right", bbox_to_anchor=(1.2, 1))

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_85.pdf", bbox_inches="tight")

