
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Sample data
time = np.arange(2000, 2021, 5)
modern = np.array([0.10, 0.15, 0.20, 0.25, 0.30])
abstract = np.array([0.25, 0.20, 0.15, 0.10, 0.05])
impressionism = np.array([0.20, 0.25, 0.20, 0.15, 0.10])
realism = np.array([0.30, 0.25, 0.20, 0.15, 0.10])
surrealism = np.array([0.15, 0.15, 0.25, 0.35, 0.45])
width = 2

barlabel = ["Modern", "Abstract", "Impressionism", "Realism", "Surrealism"]
xlabel = "Year"
ylabel = "Popularity (%)"
title = "Art Style Popularity Over Time"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xticks = [2000, 2005, 2010, 2015, 2020]

# Stacked bar chart
plt.figure(figsize=(10, 5))  # Adjusting figure size to match original image dimensions
plt.bar(time, modern, width, color="#e6194B", label=barlabel[0])
plt.bar(time, abstract, width, bottom=modern, color="#3cb44b", label=barlabel[1])
plt.bar(time, impressionism, width, bottom=modern + abstract, color="#ffe119", label=barlabel[2])
plt.bar(time, realism, width, bottom=modern + abstract + impressionism, color="#4363d8", label=barlabel[3])
plt.bar(time, surrealism, width, bottom=modern + abstract + impressionism + realism, color="#f58231", label=barlabel[4])

# Labels and title
plt.xticks(xticks)
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)

# Legend
plt.legend(loc="upper right", bbox_to_anchor=(1.4, 1))

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_86.pdf", bbox_inches="tight")
