
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.patches as mpatches
import numpy as np

# ===================
# Part 2: Data Preparation
# ===================
# Data for each subplot in the communication domain
datasets = ["5G Network", "Satellite", "WiFi", "Fiber Optic"]
models = ["Model A", "Model B", "Model C", "Model D"]
PLCC_data = {
    "5G Network": [0.955, 0.960, 0.965, 0.970],
    "Satellite": [0.880, 0.890, 0.895, 0.900],
    "WiFi": [0.910, 0.920, 0.925, 0.930],
    "Fiber Optic": [0.975, 0.980, 0.985, 0.990],
}
SROCC_data = {
    "5G Network": [0.950, 0.955, 0.960, 0.965],
    "Satellite": [0.875, 0.885, 0.890, 0.895],
    "WiFi": [0.905, 0.915, 0.920, 0.925],
    "Fiber Optic": [0.970, 0.975, 0.980, 0.985],
}
label = ["PLCC", "SROCC"]
ylabel = "Metric Values"
title = "Communication Models"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
lims = [(0.950, 0.975), (0.870, 0.905), (0.900, 0.935), (0.970, 0.995)]

# Create subplots
fig, axs = plt.subplots(1, 4, figsize=(12, 4))  # Adjusted the figure size for better clarity

# Custom color scheme
colors = ["#8dd3c7", "#ffffb3", "#bebada", "#fb8072"]
# Plot each subplot
for i, dataset in enumerate(datasets):
    x = [3, 6]  # the label locations
    width = 0.5  # the width of the bars
    for j in range(len(PLCC_data)):
        # PLCC bars
        axs[i].bar(
            x[0] + (j - 1.5) * width,
            PLCC_data[dataset][j],
            width,
            label=label[0],
            color=colors[j],
            edgecolor="white",
        )
        # SROCC bars
        axs[i].bar(
            x[1] + (j - 1.5) * width,
            SROCC_data[dataset][j],
            width,
            label=label[1],
            color=colors[j],
            edgecolor="white",
        )

    # Add some text for labels, title, and custom x-axis tick labels, etc.
    axs[i].set_ylabel(ylabel)
    axs[i].set_ylim(lims[i][0], lims[i][1])
    axs[i].set_title(dataset)
    axs[i].set_xticks(x)
    axs[i].set_xticklabels(label)

# Add legend
legend_handles = [
    mpatches.Patch(color=color, label=label) for color, label in zip(colors, models)
]
# Create legend
fig.legend(
    handles=legend_handles,
    loc="upper center",
    title=title,
    ncol=4,
    bbox_to_anchor=(0.5, 1.15),
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("bar_89.pdf", bbox_inches="tight")
